<?php
namespace lib;

abstract class YAML
{
	private static $php, $pos, $path;
	
	private static function down()
	{
		end(self::$pos);
		
		$key = key(self::$pos);
		
		self::$pos[$key] = array();
		
		self::$pos = &self::$pos[$key];
		
		self::$path[] = $key;
	}
	
	private static function up($tabs)
	{
		self::$path = array_slice(self::$path, 0, count(self::$path) - $tabs);
		
		self::$pos = &self::$php;
		
		foreach(self::$path as $key)
		{
			self::$pos = &self::$pos[$key];
		}
	}
	
	private static function append($value, $key=false)
	{
		(substr($value, 0, 1) != '0' && preg_match('/^([0-9]+)(\.([0-9]+))?$/', $value)) and $value = (float) $value;
		
		if($key)
		{
			self::$pos[$key] = $value;
		} else
		{
			self::$pos[] = $value;
		}
	}
	
	public static function parse($path)
	{
		self::$php = array();
		self::$pos = &self::$php;
		self::$path = array();
		
		$file = fopen($path, 'rb');
		$number = 0;
		
		$tab = 0;
		$indented = 0;
		
		while($line = fgets($file))
		{
			$line = str_replace(array("\n", "\r"), '', $line);
			$number++;
			
			if($length = strlen($line))
			{
				$i = 0;
				
				$indent = 0;
				
				while($i < $length and $line{$i++} == ' ') $indent++;
				
				if($i != $length)
				{
					if($indent != $indented)
					{
						$tab or $tab = $indent - $indented;
						
						if($indent > $indented)
						{
							if($indent - $indented != $tab)
							{
								throw new \Pawn\Exception('YAML', 'Unexpected indentation.', $path, $number, 201);
							} else
							{
								self::down();
							}
						} else
						{
							if(($indented - $indent) % $tab)
							{
								throw new \Pawn\Exception('YAML', 'Unexpected indentation.', $path, $number, 202);
							} else
							{
								self::up(($indented - $indent)/$tab);
							}
						}
						
						$indented = $indent;
					}
					
					$i--;
					
					if($line{$i} == '-')
					{
						self::append(substr($line, $i+2));
					} elseif($line{$i} != '#')
					{
						$name = '';
						
						while($i < $length and $line{$i++} != ':') $name .= $line{$i-1};
						while($i < $length && $line{$i} == ' ') $i++;
						
						$value = substr($line, $i);
						
						self::append($value, $name);
					}
				}
			}
		}
		
		fclose($file);
		
		return self::$php;
	}
	
	public static function cache($file)
	{
		if(!file_exists($file))
		{
			return false;
		}
		
		return "<?php\nreturn ".var_export(self::parse($file), true).';';
	}
	
	public static function fromArray($array)
	{
		return "<?php\nreturn ".var_export($array, true).';';
	}
}